@extends('layouts.app')

@section('title', 'Contact & Devis Gratuit | DÉCO BAT St Brice Sous Forêt')
@section('description', 'Contactez DÉCO BAT pour tous vos projets de plomberie, chauffage et isolation. Devis gratuit et intervention rapide dans le Val d\'Oise.')

@section('content')
<!-- Header -->
<div class="relative bg-teal-900 py-16 sm:py-24">
    <div class="absolute inset-0 bg-gradient-to-r from-teal-900 to-teal-800 overflow-hidden">
        <div class="absolute inset-0 opacity-10 bg-[url('https://www.transparenttextures.com/patterns/cubes.png')]"></div>
    </div>
    <div class="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 text-center sm:text-left">
        <h1 class="text-4xl font-extrabold text-white sm:text-5xl lg:text-6xl">Contactez-nous</h1>
        <p class="mt-4 text-xl text-teal-100 max-w-3xl">Un projet ? Une urgence ? Notre équipe est à votre écoute.</p>
    </div>
</div>

<!-- Main Section -->
<div class="bg-gray-50 py-16 sm:py-24 relative">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative z-10 -mt-32">
        <div class="bg-white rounded-2xl shadow-xl overflow-hidden flex flex-col lg:flex-row">
            
            <!-- Contact Info Sidebar -->
            <div class="bg-teal-800 text-white p-10 lg:w-2/5 flex flex-col justify-between">
                <div>
                    <h2 class="text-2xl font-bold mb-8">Nos Coordonnées</h2>
                    <ul class="space-y-8">
                        <li class="flex items-start">
                            <div class="flex-shrink-0 bg-teal-700 p-3 rounded-lg">
                                <svg class="h-6 w-6 text-white" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"/><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"/></svg>
                            </div>
                            <div class="ml-4">
                                <p class="font-medium text-teal-100">Adresse</p>
                                <p class="mt-1 font-semibold">7 Rue de la petit St Brice<br>95350 St Brice Sous Forêt</p>
                            </div>
                        </li>
                        <li class="flex items-start">
                            <div class="flex-shrink-0 bg-teal-700 p-3 rounded-lg">
                                <svg class="h-6 w-6 text-white" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"/></svg>
                            </div>
                            <div class="ml-4">
                                <p class="font-medium text-teal-100">Téléphone</p>
                                <p class="mt-1 font-semibold text-lg"><a href="tel:+331XXXXXXXXX" class="hover:text-white transition-colors">01 XX XX XX XX</a></p>
                                <p class="text-sm text-teal-300 mt-1">Lundi - Vendredi: 8h - 18h<br>Urgences 7j/7</p>
                            </div>
                        </li>
                        <li class="flex items-start">
                            <div class="flex-shrink-0 bg-teal-700 p-3 rounded-lg">
                                <svg class="h-6 w-6 text-white" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/></svg>
                            </div>
                            <div class="ml-4">
                                <p class="font-medium text-teal-100">Email</p>
                                <p class="mt-1 font-semibold"><a href="mailto:contact@decobat.fr" class="hover:underline">contact@decobat.fr</a></p>
                            </div>
                        </li>
                    </ul>
                </div>
                
                <div class="mt-12">
                     <p class="text-sm text-teal-300">DÉCO BAT est une entreprise certifiée et assurée.</p>
                </div>
            </div>

            <!-- Form -->
            <div class="p-10 lg:w-3/5 bg-white">
                <h2 class="text-2xl font-bold text-gray-900 mb-6">Envoyez-nous un message</h2>
                <form action="#" method="POST" class="space-y-6">
                    @csrf
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label for="name" class="block text-sm font-medium text-gray-700 mb-1">Nom complet</label>
                            <input type="text" name="name" id="name" required class="w-full rounded-lg border-gray-300 shadow-sm focus:border-teal-500 focus:ring-teal-500 py-3 px-4 bg-gray-50 border">
                        </div>
                        <div>
                            <label for="phone" class="block text-sm font-medium text-gray-700 mb-1">Téléphone</label>
                            <input type="tel" name="phone" id="phone" required class="w-full rounded-lg border-gray-300 shadow-sm focus:border-teal-500 focus:ring-teal-500 py-3 px-4 bg-gray-50 border">
                        </div>
                    </div>

                    <div>
                        <label for="email" class="block text-sm font-medium text-gray-700 mb-1">Email</label>
                        <input type="email" name="email" id="email" required class="w-full rounded-lg border-gray-300 shadow-sm focus:border-teal-500 focus:ring-teal-500 py-3 px-4 bg-gray-50 border">
                    </div>

                    <div>
                        <label for="service" class="block text-sm font-medium text-gray-700 mb-1">Service concerné</label>
                        <select id="service" name="service" class="w-full rounded-lg border-gray-300 shadow-sm focus:border-teal-500 focus:ring-teal-500 py-3 px-4 bg-gray-50 border">
                            <option>Demande de devis</option>
                            <option>Dépannage plomberie</option>
                            <option>Installation chauffage</option>
                            <option>Isolation</option>
                            <option>Autre demande</option>
                        </select>
                    </div>

                    <div>
                        <label for="message" class="block text-sm font-medium text-gray-700 mb-1">Message</label>
                        <textarea id="message" name="message" rows="4" required class="w-full rounded-lg border-gray-300 shadow-sm focus:border-teal-500 focus:ring-teal-500 py-3 px-4 bg-gray-50 border"></textarea>
                    </div>

                    <button type="submit" class="w-full bg-teal-600 text-white font-bold py-4 px-6 rounded-lg hover:bg-teal-700 transition-colors shadow-lg hover:shadow-xl transform hover:-translate-y-0.5 transition-all">
                        Envoyer ma demande
                    </button>
                </form>
            </div>
        </div>
    </div>
    
    <!-- Map Placeholder -->
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 mt-16">
        <div class="bg-gray-200 rounded-xl h-96 w-full flex items-center justify-center text-gray-500 shadow-inner">
            <div class="text-center">
                <svg class="h-12 w-12 mx-auto mb-4 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"/><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"/></svg>
                <p class="font-medium">Carte interactive Google Maps</p>
                <p class="text-sm">(Intégration API à prévoir)</p>
            </div>
        </div>
    </div>
</div>
@endsection
