@extends('layouts.app')

@section('title', 'CVC - Chauffage Ventilation Climatisation | DÉCO BAT')
@section('description', 'Installation et entretien de chauffage, climatisation et ventilation (CVC). Améliorez votre confort thermique.')

@section('content')
<!-- Header -->
<div class="relative bg-orange-700 py-24 sm:py-32">
    <div class="absolute inset-0 overflow-hidden">
        <img src="https://images.unsplash.com/photo-1518640467707-6811f4a6ab73?ixlib=rb-1.2.1&auto=format&fit=crop&w=1950&q=80" alt="CVC" class="w-full h-full object-cover opacity-20">
        <div class="absolute inset-0 bg-gradient-to-r from-orange-900 to-orange-800/80 mix-blend-multiply"></div>
    </div>
    <div class="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 text-center sm:text-left">
        <h1 class="text-4xl font-extrabold text-white sm:text-5xl sm:tracking-tight lg:text-6xl">Chauffage & Climatisation</h1>
        <p class="mt-6 text-xl text-orange-100 max-w-3xl">Des solutions thermiques performantes pour un confort optimal toute l'année.</p>
    </div>
</div>

<!-- Main Content -->
<div class="bg-white py-16 sm:py-24">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="grid grid-cols-1 lg:grid-cols-3 gap-12">
            
            <!-- Details -->
            <div class="lg:col-span-2">
                <h2 class="text-3xl font-bold text-gray-900 mb-8">Expertise CVC</h2>
                <p class="text-lg text-gray-600 mb-10">
                    Nous installons des systèmes modernes qui allient performance énergétique et confort d'utilisation. Nos experts vous conseillent sur la solution la plus adaptée à votre logement.
                </p>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                    <div class="bg-gray-50 rounded-xl p-6 border border-gray-100">
                        <div class="h-10 w-10 bg-orange-100 rounded-lg flex items-center justify-center mb-4 text-orange-600">
                             <svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 18.657A8 8 0 016.343 7.343S7 9 9 10c0-2 .5-5 2.986-7C14 5 16.09 5.777 17.656 7.343A7.975 7.975 0 0120 13a7.975 7.975 0 01-2.343 5.657z" /><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9.879 16.121A3 3 0 1012.015 11L11 14H9c0 .768.293 1.536.879 2.121z" /></svg>
                        </div>
                        <h3 class="font-bold text-lg mb-2">Chauffage</h3>
                        <ul class="space-y-2 text-sm text-gray-600">
                            <li>• Installation de chaudières THPE</li>
                            <li>• Pompes à chaleur Air/Eau</li>
                            <li>• Radiateurs haute performance</li>
                            <li>• Planchers chauffants</li>
                        </ul>
                    </div>

                    <div class="bg-gray-50 rounded-xl p-6 border border-gray-100">
                        <div class="h-10 w-10 bg-blue-100 rounded-lg flex items-center justify-center mb-4 text-blue-600">
                            <svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M14.828 14.828a4 4 0 01-5.656 0M9 10h.01M15 10h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" /></svg>
                        </div>
                        <h3 class="font-bold text-lg mb-2">Climatisation</h3>
                        <ul class="space-y-2 text-sm text-gray-600">
                            <li>• Climatisation réversible</li>
                            <li>• Systèmes Mono et Multi-split</li>
                            <li>• Climatisation gainable</li>
                            <li>• Entretien et recharge</li>
                        </ul>
                    </div>

                    <div class="bg-gray-50 rounded-xl p-6 border border-gray-100">
                        <div class="h-10 w-10 bg-teal-100 rounded-lg flex items-center justify-center mb-4 text-teal-600">
                           <svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15" /></svg>
                        </div>
                        <h3 class="font-bold text-lg mb-2">Ventilation</h3>
                        <ul class="space-y-2 text-sm text-gray-600">
                            <li>• VMC Simple Flux</li>
                            <li>• VMC Double Flux</li>
                            <li>• Purification de l'air</li>
                        </ul>
                    </div>
                </div>
            </div>

            <!-- Sidebar -->
            <div class="lg:col-span-1 space-y-8">
                <div class="bg-orange-50 p-6 rounded-2xl border border-orange-100 shadow-sm">
                    <h3 class="text-lg font-bold text-gray-900 mb-4">Étude Thermique</h3>
                    <p class="text-gray-600 mb-6 text-sm">Faites des économies d'énergie ! Nous réalisons une étude de vos besoins pour dimensionner parfaitement votre installation.</p>
                    <a href="{{ route('contact') }}" class="w-full flex items-center justify-center px-4 py-3 border border-transparent rounded-md shadow-sm text-base font-medium text-white bg-orange-600 hover:bg-orange-700">
                        Contacter un expert
                    </a>
                </div>
                
                 <div class="border border-gray-200 rounded-2xl p-6 shadow-sm">
                    <h3 class="text-lg font-bold mb-4 text-gray-900">Marques Partenaires</h3>
                    <div class="grid grid-cols-2 gap-4 opacity-70 grayscale hover:grayscale-0 transition-all">
                        <div class="flex items-center justify-center font-bold text-gray-400">DAIKIN</div>
                        <div class="flex items-center justify-center font-bold text-gray-400">ATLANTIC</div>
                        <div class="flex items-center justify-center font-bold text-gray-400">SAUNIER</div>
                        <div class="flex items-center justify-center font-bold text-gray-400">MITSUBISHI</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
