@extends('layouts.app')

@section('title', 'Isolation Thermique & Phonique | DÉCO BAT')
@section('description', 'Isolation des combles, murs et sols. Réduisez votre consommation énergétique et améliorez votre confort avec DÉCO BAT.')

@section('content')
<!-- Header -->
<div class="relative bg-teal-900 py-24 sm:py-32">
    <div class="absolute inset-0 overflow-hidden">
        <img src="https://images.unsplash.com/photo-1595846519845-68e298c2edd8?ixlib=rb-1.2.1&auto=format&fit=crop&w=1950&q=80" alt="Isolation" class="w-full h-full object-cover opacity-20">
        <div class="absolute inset-0 bg-gradient-to-r from-teal-950 to-teal-800/90 mix-blend-multiply"></div>
    </div>
    <div class="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 text-center sm:text-left">
        <h1 class="text-4xl font-extrabold text-white sm:text-5xl sm:tracking-tight lg:text-6xl">Isolation Performance</h1>
        <p class="mt-6 text-xl text-teal-100 max-w-3xl">L'investissement le plus rentable pour votre habitat : confort immédiat et économies durables.</p>
    </div>
</div>

<!-- Main Content -->
<div class="bg-white py-16 sm:py-24">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="grid grid-cols-1 lg:grid-cols-3 gap-12">
            
            <!-- Details -->
            <div class="lg:col-span-2">
                <div class="prose prose-teal prose-lg text-gray-500 mx-auto lg:mx-0">
                    <p class="lead text-gray-800 font-medium">
                        Une maison mal isolée perd jusqu'à 30% de sa chaleur par le toit et 25% par les murs. DÉCO BAT vous propose des solutions d'isolation haute performance conformes à la RE2020.
                    </p>
                </div>

                <div class="mt-12 space-y-10">
                    <div class="flex flex-col md:flex-row gap-6 items-start">
                        <div class="w-full md:w-1/3 rounded-lg overflow-hidden shadow-md">
                             <img src="https://images.unsplash.com/photo-1513694203232-719a280e022f?ixlib=rb-1.2.1&auto=format&fit=crop&w=500&q=60" alt="Combles" class="w-full h-48 object-cover">
                        </div>
                        <div class="w-full md:w-2/3">
                            <h3 class="text-2xl font-bold text-gray-900 mb-3">Isolation des Combles</h3>
                            <p class="text-gray-600">
                                C'est la priorité n°1 pour les économies d'énergie. Nous réalisons l'isolation par soufflage (combles perdus) ou par pose de panneaux (combles aménagés).
                                <br><span class="text-teal-600 font-medium text-sm">Matériaux : Laine de roche, Ouate de cellulose, fibre de bois.</span>
                            </p>
                        </div>
                    </div>

                    <div class="flex flex-col md:flex-row gap-6 items-start">
                        <div class="w-full md:w-1/3 rounded-lg overflow-hidden shadow-md">
                             <img src="https://images.unsplash.com/photo-1621252179027-94459d27d3ee?ixlib=rb-1.2.1&auto=format&fit=crop&w=500&q=60" alt="Isolation Murs" class="w-full h-48 object-cover">
                        </div>
                        <div class="w-full md:w-2/3">
                            <h3 class="text-2xl font-bold text-gray-900 mb-3">Isolation Intérieure (ITI)</h3>
                            <p class="text-gray-600">
                                Solution idéale en rénovation ou construction. Nous posons des systèmes complets (ossature métallique + isolant + plaque de plâtre) pour une finition parfaite prêt-à-peindre.
                            </p>
                        </div>
                    </div>
                </div>

                <!-- Process RGE -->
                <div class="mt-16 bg-teal-50 p-8 rounded-2xl border border-teal-100">
                    <h3 class="text-2xl font-bold text-teal-800 mb-6">Vos Aides Financières</h3>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div class="bg-white p-5 rounded-xl shadow-sm">
                            <h4 class="font-bold text-gray-900">MaPrimeRénov'</h4>
                            <p class="text-sm text-gray-600 mt-2">Aide de l'État pour propriétaires occupants et bailleurs.</p>
                        </div>
                        <div class="bg-white p-5 rounded-xl shadow-sm">
                            <h4 class="font-bold text-gray-900">Certificats CEE</h4>
                            <p class="text-sm text-gray-600 mt-2">Primes énergie versées par les fournisseurs d'énergie.</p>
                        </div>
                    </div>
                    <p class="mt-6 text-sm text-teal-700 italic">DÉCO BAT est certifiée RGE, condition obligatoire pour bénéficier de ces aides.</p>
                </div>
            </div>

            <!-- Sidebar -->
            <div class="lg:col-span-1 space-y-8">
                <div class="bg-white p-6 rounded-2xl border-2 border-teal-500 shadow-md">
                    <h3 class="text-xl font-bold text-gray-900 mb-2">Audit Gratuit</h3>
                    <p class="text-gray-600 mb-6 text-sm">Nous venons sur place évaluer les déperditions thermiques de votre logement.</p>
                    <a href="{{ route('contact') }}" class="w-full flex items-center justify-center px-4 py-3 border border-transparent rounded-md shadow-sm text-base font-medium text-white bg-teal-600 hover:bg-teal-700">
                        Prendre rendez-vous
                    </a>
                </div>
                
                <div class="bg-slate-50 p-6 rounded-2xl border border-gray-200">
                    <h3 class="text-lg font-bold mb-4">Isolation Acoustique</h3>
                    <p class="text-sm text-gray-600 mb-4">Besoin de calme ? Nous proposons aussi des solutions d'isolation phonique pour murs et cloisons.</p>
                    <a href="{{ route('contact') }}" class="text-teal-600 font-semibold hover:text-teal-800 text-sm">En savoir plus &rarr;</a>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
